/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.feature.battery;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.feature.battery.ErrorToast;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.Localization;
import dynamic_fps.impl.util.Logging;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import net.lostluma.battery.api.Battery;
import net.lostluma.battery.api.Manager;
import net.lostluma.battery.api.State;
import net.lostluma.battery.api.exception.LibraryLoadError;
import net.lostluma.battery.api.util.LibraryUtil;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class BatteryTracker {
    private static boolean readInitialData = false;
    private static volatile int charge = 0;
    private static volatile State status = State.UNKNOWN;
    @Nullable
    private static Manager manager = null;
    private static Collection<Battery> batteries = Collections.emptyList();
    private static final class_310 minecraft = class_310.method_1551();
    private static final Duration updateInterval = Duration.of(15L, ChronoUnit.SECONDS);

    public static int charge() {
        if (DynamicFPSConfig.INSTANCE.mockBatteryData()) {
            return 64;
        }
        return charge;
    }

    public static State status() {
        if (DynamicFPSConfig.INSTANCE.mockBatteryData()) {
            return State.CHARGING;
        }
        return status;
    }

    public static boolean hasBatteries() {
        if (DynamicFPSConfig.INSTANCE.mockBatteryData()) {
            return true;
        }
        return !batteries.isEmpty();
    }

    public static void init() {
        if (manager != null || !DynamicFPSConfig.INSTANCE.batteryTracker().enabled()) {
            return;
        }
        BatteryTracker.customizeInstallation();
        Manager temp = BatteryTracker.createManager();
        batteries = BatteryTracker.getBatteries(temp);
        if (batteries.isEmpty()) {
            if (temp != null) {
                temp.close();
            }
        } else {
            manager = temp;
            Thread.ofVirtual().name("refresh-battery").start(BatteryTracker::updateBatteries);
        }
    }

    private static State mergeStates(State a, State b) {
        if (a == b) {
            return a;
        }
        if (a == State.CHARGING || b == State.CHARGING) {
            return State.CHARGING;
        }
        if (a == State.DISCHARGING || b == State.DISCHARGING) {
            return State.DISCHARGING;
        }
        return a == State.UNKNOWN ? b : a;
    }

    private static void updateState() {
        boolean changed = false;
        float aggregate = 0.0f;
        State newStatus = State.UNKNOWN;
        for (Battery battery : batteries) {
            aggregate += battery.stateOfCharge();
            newStatus = BatteryTracker.mergeStates(newStatus, battery.state());
        }
        int newCharge = Math.round(aggregate / (float)batteries.size());
        if (readInitialData && charge != newCharge) {
            changed = true;
            int current = charge;
            minecraft.method_18858(() -> DynamicFPSMod.onBatteryChargeChanged(current, newCharge));
        }
        if (readInitialData && status != newStatus) {
            changed = true;
            State current = status;
            State updated = newStatus;
            minecraft.method_18858(() -> DynamicFPSMod.onBatteryStatusChanged(current, updated));
        }
        charge = newCharge;
        status = newStatus;
        if (!readInitialData || changed) {
            readInitialData = true;
            DynamicFPSMod.onStatusChanged(false);
        }
    }

    private static void updateBatteries() {
        boolean active = true;
        while (active) {
            for (Battery battery : batteries) {
                try {
                    battery.update();
                }
                catch (IOException e) {
                    Logging.getLogger().warn("Failed to update battery!", (Throwable)e);
                }
            }
            BatteryTracker.updateState();
            try {
                Thread.sleep(updateInterval);
            }
            catch (InterruptedException e) {
                active = false;
                Thread.currentThread().interrupt();
            }
        }
        if (manager != null) {
            manager.close();
        }
    }

    private static void customizeInstallation() {
        LibraryUtil.setCacheDir((Path)Platform.getInstance().getCacheDir());
        LibraryUtil.setAllowDownloads((boolean)DynamicFPSConfig.INSTANCE.downloadNatives());
    }

    private static Manager createManager() {
        Manager result = null;
        try {
            result = Manager.create();
        }
        catch (IOException e) {
            Logging.getLogger().warn("Failed to create battery manager!", (Throwable)e);
        }
        catch (LibraryLoadError e) {
            Logging.getLogger().warn("Battery tracker feature unavailable!");
            String path = DynamicFPSConfig.INSTANCE.downloadNatives() ? "no_support" : "no_library";
            ErrorToast.queueToast((class_2561)Localization.localized("toast", path, new Object[0]));
        }
        return result;
    }

    private static Collection<Battery> getBatteries(@Nullable Manager manager) {
        Collection<Object> result = Collections.emptyList();
        if (manager == null) {
            return result;
        }
        try {
            result = manager.batteries();
        }
        catch (IOException e) {
            Logging.getLogger().warn("Failed to query system batteries!", (Throwable)e);
        }
        return result;
    }
}

